package gov.va.med.mhv.admin.repository;

import gov.va.med.mhv.admin.model.TermsConditionsVerHist;

import java.util.List;

import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

@Repository
public interface TermsConditionsVerHistRepository extends JpaRepository<TermsConditionsVerHist, Long> {

	@Query("Select t from TermsConditionsVerHist t order by t.updatedTime desc")
	List<TermsConditionsVerHist> getVersionByUpdateTime();

	@Query("Select t from TermsConditionsVerHist t where t.id=:termsConditionsVerHistId")
	List<TermsConditionsVerHist> getVersionById(@Param("termsConditionsVerHistId") Long termsConditionsVerHistId);
	
	@Query("Select t from UserAcceptTermsHist u, TermsConditionsVerHist t where t.id=u.termsCondVerHistId and u.userProfileId=:userProfileId and to_number(substr(t.versionInfo,2)) >= to_number(:version) order by u.userUpdatedTime desc")
	List<TermsConditionsVerHist> getUserAcceptTermsVerHistByUserProfileId(@Param("userProfileId") Long userProfileId, @Param("version") String version);
	
}
